<?php
require_once DOL_DOCUMENT_ROOT . '/core/lib/admin.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/projet/class/project.class.php';
require_once DOL_DOCUMENT_ROOT . '/core/class/commonobject.class.php'; 



class tresorerie extends Commonobject{

	/**
	* @var string Error code (or message)
	* @deprecated
	* @see test::errors
	*/
	public $error;
	/**
	* @var string[] Error codes (or messages)
	*/
	public $errors = array();
	/**
	* @var string Id to identify managed objects
	*/
	// public $element = 'salle';
	/**
	* @var string Name of table without prefix where object is stored
	*/
	public $table_element = 'dtpaiement';

	
    public $id;
	public $fk_user;
	public $rows = array();
	

	public function __construct($db)
	{
		$this->db 		 = $db;
		$this->now 		 = new \DateTime("now");
		$this->now 		 = $this->now->format('Y-m-d H:i:s');
		return 1;
	}

	public function create($insert)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql  = "INSERT INTO " . MAIN_DB_PREFIX .$this->table_element." ( ";
		foreach ($insert as $column => $value) {
			$alias = (is_numeric($value)) ? "" : "'";
			if($value != ""){
				$sql_column .= " , `".$column."`";
				$sql_value .= " , ".$alias.$value.$alias;
			}
		}
		$sql .= substr($sql_column, 2)." ) VALUES ( ".substr($sql_value, 2)." )";
		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();
			$this->errors[] = 'Error '.get_class($this).' '. $this->db->lasterror();
			print_r($this->errors);die();

			return 0;
		} 
		return $this->db->db->insert_id;
	}

	public function update($id, array $data,$echo_sql=0)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		if (!$id || $id <= 0)
			return false;

        $sql =  'UPDATE ' . MAIN_DB_PREFIX .$this->table_element. ' SET ';

        if (count($data) && is_array($data))
            foreach ($data as $key => $val) {
                $val = is_numeric($val) ? $val : '"'. $val .'"';
                $val = ($val == '') ? 'NULL' : $val;
                $sql .= '`'. $key. '` = '. $val .',';
            }

        $sql  = substr($sql, 0, -1);
        $sql .= ' WHERE rowid = ' . $id;
        echo $sql;
        $resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();
			$this->errors[] = 'Error '.get_class($this).' : '. $this->db->lasterror();
			return -1;
		} 
		return 1;
	}
	
	public function SelectProjectsAuthorized($selected='', $user, $projectset='')
	{
    	global $langs;
		$project = new Project($this->db);
		$sql = "SELECT p.*";
		$sql .= " FROM ".MAIN_DB_PREFIX."projet as p";
		$sql .= " WHERE";
		$sql .= " p.entity IN (".getEntity('project').")";
		$projectsListId = $project->getProjectsAuthorizedForUser($user, $projectset, 1);
		$sql .= "AND p.rowid IN (".$projectsListId.")";

		$resql = $this->db->query($sql);
		$html = '<select class="select_proj_visibl" name="proj_id" onchange="this.form.submit()">';
		// $html .= '<option value="">'.$langs->Trans("All").'</option>';
		if ($resql)
		{
			while ($obj = $this->db->fetch_object($resql))
			{
				$html .= '<option value="'.$obj->rowid.'"' ;
				if($selected == $obj->rowid) $html .= 'selected';
				$html .= '>';
				$html .= $obj->ref;
				if($obj->ref && $obj->title)
					$html .= ' - ';
				// $html .= $obj->title;
				$html .= dol_trunc($obj->title,100);

				$html .= '</option>';
			}
		}
		$html .= '</select>';
		
		return $html;
	}

	public function GetProjects($projectset=0)
	{
		$project = new Project($this->db);
		$sql = "SELECT p.*";
		$sql .= " FROM ".MAIN_DB_PREFIX."projet as p";
		$sql .= " WHERE";
		$sql .= " p.entity IN (".getEntity('project').")";
		$projectsListId = $project->getProjectsAuthorizedForUser($user, $projectset, 1);
		$sql .= "AND p.rowid IN (".$projectsListId.")";
		$data = [];
		$resql = $this->db->query($sql);
		if ($resql)
		{
			while ($obj = $this->db->fetch_object($resql))
			{
				$data[$obj->rowid]= dol_trunc($obj->title,40);
			}
		}
		
		return $data;
	}

	public function getYearsProject($year="")
    {
    	global $langs;

        $sql = 'SELECT DISTINCT YEAR(dateo) as years FROM ' . MAIN_DB_PREFIX.'projet_task';
        $resql = $this->db->query($sql);
		$html = '<select class="select_proj_year" name="proj_year" onchange="submitByYear(this)">';
		$html .= '<option value="">'.$langs->Trans("All").'</option>';
        if ($resql) {
            $num = $this->db->num_rows($resql);
            while ($obj = $this->db->fetch_object($resql)) {
				$html .= '<option value="'.$obj->years.'"';
				if($year == $obj->years) $html .= 'selected';
				$html .= '>'.$obj->years.'</option>';
            }
            $this->db->free($resql);
        }
		$html .= '</select>';

        return $html;
    }

  	public function InvoiceClients($socid='')
  	{
  		$data=[];
  		$i=0;
  		$opts = '<select class="invoiceclient" name="factid" id="factsoc" onchange="getlineprocuct(this)">';
  		$opts .='<option></option>';
  		$sql = 'SELECT f.rowid as facid, f.ref, f.total_ttc, f.multicurrency_code, f.multicurrency_total_ttc, f.type,';
        $sql .= ' f.datef as df, f.fk_soc as socid, f.date_lim_reglement as dlr';
        $sql .= ' FROM '.MAIN_DB_PREFIX.'facture as f';
		$sql .= ' WHERE f.entity IN ('.getEntity('facture').')';
		if($socid)
        	$sql .= ' AND f.fk_soc = '.$socid;
		// Can pay invoices of all child of parent company
		// if (!empty($conf->global->FACTURE_PAYMENTS_ON_DIFFERENT_THIRDPARTIES_BILLS) && !empty($facture->thirdparty->parent)) {
		// 	$sql .= ' OR f.fk_soc IN (SELECT rowid FROM '.MAIN_DB_PREFIX.'societe WHERE parent = '.$facture->thirdparty->parent.')';
		// }
		// // Can pay invoices of all child of myself
		// if (!empty($conf->global->FACTURE_PAYMENTS_ON_SUBSIDIARY_COMPANIES)) {
		// 	$sql .= ' OR f.fk_soc IN (SELECT rowid FROM '.MAIN_DB_PREFIX.'societe WHERE parent = '.$facture->thirdparty->id.')';
		// }
        $sql .= ' AND f.paye = 0';
        $sql .= ' AND f.fk_statut = 1'; // Statut=0 => not validated, Statut=2 => canceled
        // if ($facture->type != Facture::TYPE_CREDIT_NOTE)
        // {
        //     $sql .= ' AND type IN (0,1,3,5)'; // Standard invoice, replacement, deposit, situation
        // }
        // else
        // {
        // 		$sql .= ' AND type = 2'; // If paying back a credit note, we show all credit notes
        // }
        // Sort invoices by date and serial number: the older one comes first
        $sql .= ' ORDER BY f.datef ASC, f.ref ASC';
        $resql = $this->db->query($sql);
        if ($resql)
        {
            $num = $this->db->num_rows($resql);
            if ($num > 0)
            {
            	while ($i < $num)
                {
                    $objp = $this->db->fetch_object($resql);
                    $data[$i]=$objp;
                    $i++;
                    $opts.='<option value="'.$objp->facid.'">'.$objp->ref.'</option>';
                }
            }
    	}
    	$opts .'</select>';
    	return $opts;
  	}

  	public function PayementFacture($facid='', $fk_reglement=0)
  	{
  		// Payments already done (from payment on this invoice)
  		$html .= '<select name="fk_reglement" id="fk_reglement" >';
		$sql = 'SELECT p.datep as dp, p.ref, p.num_paiement as num_payment, p.rowid, p.fk_bank,';
		$sql .= ' c.code as payment_code, c.libelle as payment_label,';
		$sql .= ' pf.amount,';
		$sql .= ' ba.rowid as baid, ba.ref as baref, ba.label, ba.number as banumber, ba.account_number, ba.fk_accountancy_journal';
		$sql .= ' FROM '.MAIN_DB_PREFIX.'paiement_facture as pf, '.MAIN_DB_PREFIX.'paiement as p';
		$sql .= ' LEFT JOIN '.MAIN_DB_PREFIX.'c_paiement as c ON p.fk_paiement = c.id';
		$sql .= ' LEFT JOIN '.MAIN_DB_PREFIX.'bank as b ON p.fk_bank = b.rowid';
		$sql .= ' LEFT JOIN '.MAIN_DB_PREFIX.'bank_account as ba ON b.fk_account = ba.rowid';
		$sql .= ' WHERE pf.fk_facture = '.$facid.' AND pf.fk_paiement = p.rowid';
		$sql .= ' AND p.entity IN ('.getEntity('invoice').')';
		$sql .= ' ORDER BY p.datep, p.tms';

		$result = $this->db->query($sql);
		if ($result) {
			$num = $this->db->num_rows($result);
			$i = 0;

			if ($num > 0) {
				while ($i < $num) {
					$objp = $this->db->fetch_object($result);
					$html .='<option value="'.$objp->rowid.'"';
					if($fk_reglement == $objp->rowid) $html .= 'selected';
					$html .= '>'.$objp->ref.'</option>';
					$i++;
				}
			}
	  	}
	  	$html .= '</select>';
	  	return $html;
  	}

  	public function FirstPayment($facid='')
  	{
  		$sql = "SELECT p.rowid as fk_reglement FROM ".MAIN_DB_PREFIX."paiement as p LEFT JOIN ".MAIN_DB_PREFIX."paiement_facture as pf ON p.rowid = pf.fk_paiement LEFT JOIN ".MAIN_DB_PREFIX."facture as f ON pf.fk_facture = f.rowid WHERE f.rowid=".$facid;
  		$result = $this->db->query($sql);
		if ($result) {
			while ($obj = $this->db->fetch_object($result)){
				$fk_reglement = $obj->fk_reglement;
			}
	  	}
	  	return $fk_reglement;
  	}
  	public function TotalReglment($socid='', $filter='')
  	{
  		$sql = "SELECT SUM(pf.amount) as totalrglm FROM ".MAIN_DB_PREFIX."paiement_facture as pf LEFT JOIN ".MAIN_DB_PREFIX."facture as f ON pf.fk_facture = f.rowid WHERE f.fk_soc=".$socid;


  		if($filter) $sql .= ' '.$filter;
  		$result = $this->db->query($sql);
		if ($result) {
			while ($obj = $this->db->fetch_object($result)){
				$total = $obj->totalrglm;
			}
	  	}
	  	return $total;
  	}

  	public function TotalRemisSoc($socid='', $filter='')
  	{
  		$sql = "SELECT re.rowid, SUM(re.amount_ht) as sum, re.amount_tva, re.amount_ttc,";
		$sql .= " re.description, re.fk_facture_source";
		$sql .= " FROM ".MAIN_DB_PREFIX."societe_remise_except as re";
		$sql .= " WHERE fk_facture IN (SELECT rowid FROM ".MAIN_DB_PREFIX."facture WHERE fk_soc= ".$socid;
		if($filter) $sql .= ' '.$filter;
		$sql .= ")";

  		$result = $this->db->query($sql);
		if ($result) {
			while ($obj = $this->db->fetch_object($result)){
				$total = $obj->sum;
			}
	  	}
	  	return $total;
  	}



  	public function TotalRemisSoc2($socid='', $filter='')
  	{
  		$sql = "SELECT f.rowid FROM ".MAIN_DB_PREFIX."facture as f";
		$sql .= " WHERE fk_soc= ".$socid;
		if($filter) $sql .= ' '.$filter;
		// echo $sql;
		$resteapayer=0;
  		$resql = $this->db->query($sql);
		if ($resql) {
			while ($obj = $this->db->fetch_object($resql)){
				// $total = $obj->sum;
				$objecttmp = new Facture($this->db);
				$result = $objecttmp->fetch($obj->rowid);
				if ($result > 0)
				{
					$totalpaye = $objecttmp->getSommePaiement();
					$totalcreditnotes = $objecttmp->getSumCreditNotesUsed();
					$totaldeposits = $objecttmp->getSumDepositsUsed();


					$resteapayer += ($totalpaye + $totalcreditnotes + $totaldeposits);

					// echo "totalpaye:".$totalpaye;;
					// echo "totalcreditnotes:".$totalcreditnotes;;
					// echo "totaldeposits:".$totaldeposits;;
					// echo $resteapayer;
				}
			}
	  	}
	  	// die();
	  	return $resteapayer;
  	}




  	public function Dt_facture($facid, $fk_paiement)
  	{
  		$sql ="SELECT f.rowid as doc_id, f.ref as doc_number, f.type as doc_type, r.datep as dateprint, f.fk_statut as status, f.paye as paid, d.description as description, d.label as label, d.fk_product as product_id, d.qty as prod_qty, d.total_ht as total_ht, p.ref as ref, p.rowid as prod_id, p.fk_product_type as prod_type,  p.entity as pentity, p.ref as prod_ref, p.label as product_label, pf.amount, d.product_type as type,  p.tva_tx as tva FROM llx_paiement_facture as pf, llx_paiement as r, llx_facture as f,llx_facturedet as d LEFT JOIN llx_product as p ON d.fk_product = p.rowid WHERE f.rowid = pf.fk_facture AND pf.fk_paiement = r.rowid AND r.rowid = ".$fk_paiement." AND d.fk_facture = f.rowid AND f.rowid=".$facid." AND f.entity IN (1)";
  		$result = $this->db->query($sql);
		if ($result) {
			$num = $this->db->num_rows($result);
			$i = 0;

			if ($num > 0) {
				while ($i < $num) {
					$data[$i] = $this->db->fetch_object($result);
					$i++;
				}
			}
	  	}

	  	return $data;
  	}	


  	public function select_nbmonth($value='', $name="nb_month", $class="maxwidth50imp valignmiddle")
  	{
  		$select .= '<select name="'.$name.'" id="nb_month" class="'.$class.'">';
  		for ($i=3; $i <=12 ; $i++) { 
  			$li = $i;
  			if ( strlen($i) < 2 && $i <= 9) $li = "0".$i;
  			$select .= '<option value="'.$i.'" >'.$li.'</option>';
  		}
  		$select .= '</select>';
  		$select = str_replace('value="'.$value.'"', 'value="'.$value.'" selected', $select);
  		return $select;
  	}

  	public function select_nbligne($value='',$element)
  	{
  		// $select .= '<select name="'.$name.'" id="nb_month" class="'.$class.'">';
  		$select .='<select class="flat selectlimit" onchange="change_nbligne(this,\''.$element.'\')" name="limit" title="Nombre ligne par page"><option name="3">3</option>';
			$select .= '<option value="5">5</option>';
			$select .= '<option value="8">8</option>';
			$select .= '<option value="10">10</option>';
			$select .= '<option value="15">15</option>';
			$select .= '<option value="20">20</option>';
		$select .= '</select>';
  		$select = str_replace('value="'.$value.'"', 'value="'.$value.'" selected', $select);
  		return $select;
  	}

  	public function getData($sql='',$page=0, $limit=3)
	{
		$arrayresult = [];
		global $db;
		$limit = $limit;
		$offset = (int)$page * $limit;

		if($sql){
			$sqlT = $sql;
			$resqlT = $this->db->query($sqlT);
			$lim = $limit+1;
			$sql .= ' limit '.$offset.','.$lim;
			$resql = $this->db->query($sql);

			$numt = $resqlT->num_rows;
			$num = $resql->num_rows;

			$arrayresult['num'] = $resql->num_rows;
			$arrayresult['numt'] = $resqlT->num_rows;
			$sqlT .= ', month';
			$resql2 = $this->db->query($sqlT);
			$num2 = $resql2->num_rows;
			$i = 0;
			if($resql2){
				while ( $obj = $this->db->fetch_object($resql2))
				{
					$arrayresult2[$obj->rowkey][$obj->month] = $obj;
					$i++;
				}
			}
			$i = 0;
			if($resql){
				while ($i < min($num, $limit))
				{
					$obj = $this->db->fetch_object($resql); 
					$arrayresult['data'][$obj->rowkey] = $arrayresult2[$obj->rowkey];
					$i++;
				}
			}
		}

		return $arrayresult;
	}

	function PaginationJs($page, $file, $options = '', $num = -1, $totalnboflines = '', $element="", $limit = -1)
	{
		global $conf, $langs;

		$savlimit = $limit;
		$savtotalnboflines = $totalnboflines;
		$totalnboflines = abs($totalnboflines);
		// $num ++;
		if ($limit < 0) $limit = 3;
		if ($savlimit != 0 && (($num > $limit) || ($num == -1) || ($limit == 0)))
		{
			$nextpage = 1;
		}
		else
		{
			$nextpage = 0;
		}
		// print 'module::'.$module.'totalnboflines='.$totalnboflines.'-savlimit='.$savlimit.'-limit='.$limit.'-num='.$num.'-nextpage='.$nextpage.'-page='.$page.'<br>';

		$htmlpagination .= "\n";
		// $htmlpagination .= '<table class="centpercent notopnoleftnoright table-fiche-title"><tr>'; // maring bottom must be same than 
		// $htmlpagination .= '<td class="nobordernopadding valignmiddle right">';
		
		// Show navigation bar
		$pagelist = '';

		if ($savlimit != 0 && ($page > 0 || $num > $limit))
		{
			if ($totalnboflines)	// If we know total nb of lines
			{
				// Define nb of extra page links before and after selected page + ... + first or last
				$maxnbofpage = (empty($conf->dol_optimize_smallscreen) ? 4 : 0);

				if ($limit > 0) $nbpages = ceil($totalnboflines / $limit);
				else $nbpages = 1;
				$cpt = ($page - $maxnbofpage);
				if ($cpt < 0) { $cpt = 0; }

				if ($cpt >= 1)
				{
					// $pagelist .= '<li class="pagination"><a data-a="e1" href="'.$file.'?page=0'.$options.'">1</a></li>';
					$pagelist .= '<li class="pagination" onclick="GoToPage(this,\''.$element.'\',\''.$limit.'\')"><input type="hidden" class="topage" value="0"><a>1</a></li>';
					if ($cpt > 2) $pagelist .= '<li class="pagination"><span class="inactive">...</span></li>';
					// elseif ($cpt == 2) $pagelist .= '<li class="pagination"><a data-a="e2" href="'.$file.'?page=1'.$options.'">2</a></li>';
				}
				do
				{
					// if($module == 'user'){
						// print 'cpt::'.$savlimit.'<br>';
						// print 'totalnboflines::'.$totalnboflines.'<br>';
						// print 'nbpages::'.$nbpages.'<br>';
						// print 'page::'.$page.'<br>';
						// print 'limit::'.$limit.'<br>';
						// print 'maxnbofpage::'.$maxnbofpage.'<br>';
					// }
					if ($cpt == $page)
					{
						$pagelist .= '<li class="pagination"><span class="active">'.($page + 1).'</span></li>';
					}
					else
					{
						$pagelist .= '<li class="pagination" onclick="GoToPage(this,\''.$element.'\',\''.$limit.'\')" ><input type="hidden" class="topage" value="'.$cpt.'"><a>'.($cpt + 1).'</a></li>';
					}
					$cpt++;
				}
				while ($cpt < $nbpages && $cpt <= $page + $maxnbofpage);

				if ($cpt < $nbpages)
				{
					if ($cpt < $nbpages - 2) $pagelist .= '<li class="pagination"><span class="inactive">...</span></li>';
					// elseif ($cpt == $nbpages - 2) $pagelist .= '<li class="pagination"><a data-a="e3" href="'.$file.'?page='.($nbpages - 2).$options.'">'.($nbpages - 1).'</a></li>';
					// $pagelist .= '<li class="pagination"><a data-a="e4" href="'.$file.'?page='.($nbpages - 1).$options.'">'.$nbpages.'</a></li>';
					$pagelist .= '<li class="pagination" onclick="GoToPage(this,\''.$element.'\',\''.$limit.'\')"><input type="hidden" class="topage" value="'.($nbpages - 1).'"><a>'.$nbpages.'</a></li>';
				}
			}
			// else
			// {
			// 	$pagelist .= '<li class="pagination"><span class="active">'.($page + 1)."</li>";
			// }
		}
		if ($savlimit) {
			$htmlpagination .= '<div class="pagination">';
				$htmlpagination .= '<ul>';
				if($totalnboflines > $savlimit){
					$htmlpagination .= $this->select_nbligne($limit,$element);
				}
				$htmlpagination .= $this->fleche_navigation($page, $file, $options, $nextpage, $pagelist, $savlimit, $element); // output the div and ul for previous/last completed with page numbers into $pagelist
			$htmlpagination .= '</ul></div>'."\n";
		}

		// $htmlpagination .= '</td>';

		// $htmlpagination .= '</tr></table>'."\n";
		$htmlpagination .= "<!-- End title -->\n\n";
		return $htmlpagination;
	}

	function fleche_navigation($page, $file, $options = '', $nextpage = 0, $pagelist, $limit = -1, $element='')
	{
		global $conf, $langs;
		
		if ($page > 0)
		{
			$pg = $page-1;
			$html .= '<li class="pagination" onclick="GoToPage(this,\''.$element.'\',\''.$limit.'\')" > <input type="hidden" class="topage" value="'.$pg.'"> <a class="paginationprevious" > <i class="fa fa-chevron-left" title="'.dol_escape_htmltag($langs->trans("Previous")).'"></i></a></li>';
		}
		if ($pagelist)
		{
			$html .= $pagelist;
		}
		if ($nextpage > 0)
		{
			$pg = $page+1;
			$html .= '<li class="pagination" onclick="GoToPage(this,\''.$element.'\',\''.$limit.'\')" > <input type="hidden" class="topage" value="'.$pg.'"> <a class="paginationnext" ><i class="fa fa-chevron-right" title="'.dol_escape_htmltag($langs->trans("Next")).'"></i></a></li>';
		}
		// if ($afterarrows)
		// {
		// 	$html .= '<li class="paginationafterarrows">';
		// 	$html .= $afterarrows;
		// 	$html .= '</li>';
		// }
		return $html;
	}
}
